#include < amxmodx >
#include < fun >
#include < engine >
#include < fakemeta >
#include < colorchat >
#include < hamsandwich >

#define ADMIN_LEVEL ADMIN_MAP

new gConfigFile[ 128 ];

new Float:gLightMinY[ 3 ] = { -8.0, -8.0, -8.0 }; 
new Float:gLightMaxY[ 3 ] = { 8.0, 8.0, 8.0 }; 

new light_properites[ 33 ][ 4 ];
new editing_value[ 33 ];

new const gszModel[] = "sprites/lightmaker/lightmaker.spr";
new const gszFolder[] = "addons/amxmodx/data/lights";
new const gszLightClassName[] = "lightmaker";
new const gszPrefix[] = "";
new const gszVersion[] = "1.5";

public plugin_init( ) 
{
	register_plugin( "Light Maker", gszVersion, "Juice" );
	register_clcmd( "say /light", "CmdLightMenu" );
	register_forward( FM_Think, "fwdThink" );
	
	register_cvar( "lightmaker_version", gszVersion, FCVAR_SERVER | FCVAR_SPONLY ); 
	
	register_menucmd( register_menuid("LightMenu"), 1023, "handleLightMenu" );
	register_menucmd( register_menuid("OptionsMenu"), 1023, "handleOptionsMenu" );
	register_menucmd( register_menuid("ColorMenu"), 1023, "handleColorMenu" );
	register_menucmd( register_menuid("TemplatesMenu"), 1023, "handleTemplatesMenu" );
}

public plugin_precache( ) 
	precache_model( gszModel );

public client_putinserver( id )
{
	editing_value[id] = 10;
	light_properites[id][0] = 30;
	light_properites[id][1] = 255;
	light_properites[id][2] = 255;
	light_properites[id][3] = 255;
}

public plugin_cfg( ) 
{
	new szMapName[ 32 ];
	get_mapname( szMapName, 31 );
	strtolower( szMapName );
	
	formatex( gConfigFile, 127, gszFolder );
	
	if( !dir_exists( gConfigFile ) ) 
	{
		mkdir( gConfigFile );
		format( gConfigFile, 127, "%s/%s.txt", gConfigFile, szMapName );
		return;
	}
	
	format( gConfigFile, 127, "%s/%s.txt", gConfigFile, szMapName );
	
	if( !file_exists( gConfigFile ) )
		return;
	
	LoadLights(0);
	
}

public DeleteLight( id ) 
{
	new Float:vOrigin[ 3 ], szClassName[ 12 ], iEntity = -1, iDeleted;
	entity_get_vector( id, EV_VEC_origin, vOrigin );
	
	while( ( iEntity = find_ent_in_sphere( iEntity, vOrigin, 100.0 ) ) > 0 )
	{
		entity_get_string( iEntity, EV_SZ_classname, szClassName, 11 );
		
		if( equal( szClassName, gszLightClassName ) ) 
		{
			remove_entity( iEntity );
			iDeleted++;
		}
	}
	
	if( iDeleted == 0 ) 
	{
		ColorChat( id, RED, "^x04%s^x01You need to stand near^x01 Light to remove it!", gszPrefix );
	}
	//client_print( id, print_chat,"%sYou need to stand near Light to remove it!", gszPrefix );
	return PLUGIN_HANDLED;
}

public CmdLightMenu( id )
{
	ShowLightMenu( id );
	return PLUGIN_HANDLED;
}

public ShowLightMenu(id) 
{
	new MenuBody[512], szColor[3], access[3], len, keys;
	access = (get_user_flags(id) & ADMIN_LEVEL ? "\w" : "\d");
	formatex(szColor, 3, access) 
	
	len = format(MenuBody, 511, "\y%sLight Menu \r[Radius: \y%d\r] - \yBy Juice", gszPrefix, light_properites[id][0]);
	len += format(MenuBody[len], 511-len, "^n\r1. %sRadius +", szColor);
	len += format(MenuBody[len], 511-len, "^n\r2. %sCreate Light", szColor);
	len += format(MenuBody[len], 511-len, "^n\r3. %sRadius -", szColor);
	len += format(MenuBody[len], 511-len, "^n\r4. %sDelete Light^n", szColor);
	len += format(MenuBody[len], 511-len, "^n\r5. \wColor Selection \r[R: \y%d \r| G: \y%d \r| B: \y%d\r]^n", light_properites[id][1], light_properites[id][2],light_properites[id][3]);
	len += format(MenuBody[len], 511-len, "^n\r6. %sSwitch Noclip", szColor);
	len += format(MenuBody[len], 511-len, "^n\r7. %sSwitch GodMode^n",szColor);
	len += format(MenuBody[len], 511-len, "^n\r9. \wOptions Menu^n");
	len += format(MenuBody[len], 511-len, "^n\r0. \wExit");
	
	keys = ( 1<<5 | 1<<9 );
	
	if( get_user_flags(id) & ADMIN_LEVEL ) 
	keys |= ( 1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<6 | 1<<8 );

	show_menu(id, keys, MenuBody, -1, "LightMenu");
}

public ShowOptionsMenu(id) 
{
	new MenuBody[512], szColor[3], access[3], len, keys;
	access = (get_user_flags(id) & ADMIN_LEVEL ? "\w" : "\d");
	formatex(szColor, 3, access) 
	
	len = format(MenuBody, 511, "\y%sLight Options Menu", gszPrefix);
	len += format(MenuBody[len], 511-len, "^n\r1. %sLoad from file", szColor);
	len += format(MenuBody[len], 511-len, "^n\r2. %sDelete all lights", szColor);
	len += format(MenuBody[len], 511-len, "^n\r3. %sSave to file", szColor);
	len += format(MenuBody[len], 511-len, "^n\r4. %sEditing Amount: \y%d^n", szColor, editing_value[id]);
	len += format(MenuBody[len], 511-len, "^n\r6. %sSwitch Noclip", szColor);
	len += format(MenuBody[len], 511-len, "^n\r7. %sSwitch GodMode^n", szColor);
	len += format(MenuBody[len], 511-len, "^n\r0. \wBack");
	
	keys = ( 1<<9 );
	
	if(get_user_flags(id) & ADMIN_LEVEL)
	keys |= ( 1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<5 | 1<<6 );
	
	show_menu(id, keys, MenuBody, -1, "OptionsMenu");
}

public ShowColorMenu( id ) 
{
	new MenuBody[512], szColor[3], access[3], len, keys;
	access = (get_user_flags(id) & ADMIN_LEVEL ? "\w" : "\d");
	formatex(szColor, 3, access) 
	
	len = format(MenuBody, 511, "\y%sColor Selection Menu^n\r[R: \y%d \r| G: \y%d \r| B: \y%d\r]", gszPrefix, light_properites[id][1], light_properites[id][2],light_properites[id][3]);
	len += format(MenuBody[len], 511-len, "^n\r1. %sRed +", szColor);
	len += format(MenuBody[len], 511-len, "^n\r2. %sRed -", szColor);
	len += format(MenuBody[len], 511-len, "^n\r3. %sGreen +", szColor);
	len += format(MenuBody[len], 511-len, "^n\r4. %sGreen -", szColor);
	len += format(MenuBody[len], 511-len, "^n\r5. %sBlue +", szColor);
	len += format(MenuBody[len], 511-len, "^n\r6. %sBlue -^n", szColor);
	len += format(MenuBody[len], 511-len, "^n\r9. %sColor Templates^n", szColor);
	len += format(MenuBody[len], 511-len, "^n\r0. \wBack");
	
	keys = ( 1<<9 );
	
	if(get_user_flags(id) & ADMIN_LEVEL)
	keys |= ( 1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<5 | 1<<8 );

	show_menu( id, keys, MenuBody, -1, "ColorMenu" );
}

public ShowTemplatesMenu( id ) 
{
	new MenuBody[512], szColor[3], access[3], len, keys;
	access = (get_user_flags(id) & ADMIN_LEVEL ? "\w" : "\d");
	formatex(szColor, 3, access) 
	
	len = format(MenuBody, 511, "\y%sChoose Color Template:", gszPrefix);
	len += format(MenuBody[len], 511-len, "^n\r1. %sWhite", szColor);
	len += format(MenuBody[len], 511-len, "^n\r2. %sRed", szColor);
	len += format(MenuBody[len], 511-len, "^n\r3. %sGreen", szColor);
	len += format(MenuBody[len], 511-len, "^n\r4. %sBlue", szColor);
	len += format(MenuBody[len], 511-len, "^n\r5. %sAqua", szColor);
	len += format(MenuBody[len], 511-len, "^n\r6. %sYellow", szColor);
	len += format(MenuBody[len], 511-len, "^n\r7. %sOrange", szColor);
	len += format(MenuBody[len], 511-len, "^n\r8. %sPink^n", szColor);
	len += format(MenuBody[len], 511-len, "^n\r0. \wBack");
	
	keys = ( 1<<9 );
	
	if(get_user_flags(id) & ADMIN_LEVEL)
	keys |= ( 1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<5 | 1<<6 | 1<<7 );

	show_menu( id, keys, MenuBody, -1, "TemplatesMenu" );
}

public handleLightMenu( id, key )
{
	new szName[33];
	get_user_name(id, szName, 32);
	switch(key + 1)
	{
		case 1:
		{
			light_properites[id][0] += editing_value[id];
			if(light_properites[id][0] > 40)
			{
				light_properites[id][0] = 40;
			}
			ShowLightMenu( id );
		}
		case 2:
		{
			CreateLightAiming( id );
			ShowLightMenu( id );
		}
		case 3:
		{
			light_properites[id][0] -= editing_value[id];
			if(light_properites[id][0] <= 0)
			{
				light_properites[id][0] = 5;
			}
			ShowLightMenu( id );
		}
		case 4:
		{
			DeleteLight(id);
			ShowLightMenu(id);
		}
		case 5:
		{
			ShowColorMenu(id);
		}
		case 6:
		{
			set_user_noclip(id, get_user_noclip(id) ? 0 : 1);
			ColorChat(0, RED, "^x04%s^x03%s^x01 has %sabled]^x01 Noclip", gszPrefix, szName, get_user_noclip(id) ? "^x04[en" : "^x03[dis");
			ShowOptionsMenu(id);
		}
		case 7:
		{
			set_user_godmode(id, get_user_godmode(id) ? 0 : 1);
			ColorChat(0, RED, "^x04%s^x03%s^x01 has %sabled]^x01 Godmode", gszPrefix, szName, get_user_godmode(id) ? "^x04[en" : "^x03[dis");
			ShowOptionsMenu(id);
		}
		case 9:
		{
			ShowOptionsMenu(id);
		}
	}
}

public handleOptionsMenu(id, key) 
{
	new szName[33];
	get_user_name(id, szName, 32);
	switch (key + 1) 
	{
		case 1:
		{
			LoadLights(id);
			ShowOptionsMenu(id);
		}
		case 2:
		{
			DeleteAllLights(id);
			ShowOptionsMenu(id);
		}
		case 3:
		{	
			SaveLights(id);
			ShowOptionsMenu(id);
		}
		case 4:
		{
			editing_value[id] += 5;
			if(editing_value[id] == 6)	
			{
				editing_value[id] = 5;
			}
			else if(editing_value[id] > 50)
			{
				editing_value[id] = 1;
			}
			ShowOptionsMenu(id);
		}
		case 6:
		{
			set_user_noclip(id, get_user_noclip(id) ? 0 : 1);
			ColorChat(0, RED, "^x04%s^x03%s^x01 has %sabled]^x01 Noclip", gszPrefix, szName, get_user_noclip(id) ? "^x04[en" : "^x03[dis");
			ShowOptionsMenu(id);
		}
		case 7:
		{
			set_user_godmode(id, get_user_godmode(id) ? 0 : 1);
			ColorChat(0, RED, "^x04%s^x03%s^x01 has %sabled]^x01 Godmode", gszPrefix, szName, get_user_godmode(id) ? "^x04[en" : "^x03[dis");
			ShowOptionsMenu(id);
		}
		case 10:
		{
			ShowLightMenu(id);
		}
	}
}

public handleColorMenu(id, key) 
{
	switch (key + 1) 
	{
		case 1:
		{
			light_properites[id][1] += editing_value[id];
			if(light_properites[id][1] > 255)
			{
				light_properites[id][1] = 255;
			
			}
			ShowColorMenu(id);
		}
		case 2:
		{
			light_properites[id][1] -= editing_value[id];
			if(light_properites[id][1] < 0)
			{
				light_properites[id][1] = 0;
			}
			ShowColorMenu(id);
		}
		case 3:
		{	
			light_properites[id][2] += editing_value[id];
			if(light_properites[id][2] > 255)
			{
				light_properites[id][2] = 255;
			}
			ShowColorMenu(id);
		}
		case 4:
		{
			light_properites[id][2] -= editing_value[id];
			if(light_properites[id][2] < 0)
			{
				light_properites[id][2] = 0;
			}
			ShowColorMenu(id);
		}
		case 5:
		{
			light_properites[id][3] += editing_value[id];
			if(light_properites[id][3] > 255)
			{
				light_properites[id][3] = 255;
			}
			ShowColorMenu(id);
		}
		case 6:
		{
			light_properites[id][3] -= editing_value[id];
			if(light_properites[id][3] < 0)
			{
				light_properites[id][3] = 0;
			}
			ShowColorMenu(id);
		}
		case 9:
		{
			ShowTemplatesMenu(id);
		}
		case 10:
		{
			ShowLightMenu(id);
		}
	}
}

public handleTemplatesMenu(id, key) 
{
	switch (key + 1) 
	{
		case 1:
		{
			light_properites[id][1] = 255;
			light_properites[id][2] = 255;
			light_properites[id][3] = 255;
			ShowLightMenu(id);
		}
		case 2:
		{
			
			light_properites[id][1] = 255;
			light_properites[id][2] = 0;
			light_properites[id][3] = 0;
			ShowLightMenu(id);
		}
		case 3:
		{	
			
			light_properites[id][1] = 0;
			light_properites[id][2] = 255;
			light_properites[id][3] = 0;
			ShowLightMenu(id);
		}
		case 4:
		{
			
			light_properites[id][1] = 0;
			light_properites[id][2] = 0;
			light_properites[id][3] = 255;
			ShowLightMenu(id);
		}
		case 5:
		{
			light_properites[id][1] = 0;
			light_properites[id][2] = 205;
			light_properites[id][3] = 210;
			ShowLightMenu(id);
		}
		case 6:
		{
			light_properites[id][1] = 255;
			light_properites[id][2] = 255;
			light_properites[id][3] = 0;
			ShowLightMenu(id);
		}
		case 7:
		{
			
			light_properites[id][1] = 255;
			light_properites[id][2] = 140;
			light_properites[id][3] = 0;
			ShowLightMenu(id);
		}
		case 8:
		{
			
			light_properites[id][1] = 240;
			light_properites[id][2] = 20;
			light_properites[id][3] = 140;
			ShowLightMenu(id);
		}
		case 10:
		{
			ShowLightMenu(id);
		}
	}
}

CreateLightAiming( id )
{
	new origin[ 3 ], Float:vOrigin[ 3 ];
	get_user_origin( id, origin, 3 );
	IVecFVec( origin, vOrigin );
	vOrigin[ 2 ] += gLightMaxY[ 2 ];
	
	new iRadius = light_properites[id][0];
	new iR = light_properites[id][1];
	new iG = light_properites[id][2];
	new iB = light_properites[id][3];
		
	CreateLight( vOrigin, iRadius, iR, iG, iB );
}

CreateLight( Float:vOrigin[ 3 ], iRadius, iR, iG, iB )
{
	new iEntity = create_entity( "info_target" );

	if( is_valid_ent( iEntity ) )
	{
		entity_set_string( iEntity, EV_SZ_classname, gszLightClassName );
		entity_set_int( iEntity, EV_INT_solid, SOLID_NOT );
		entity_set_int( iEntity, EV_INT_movetype, MOVETYPE_NONE );
		entity_set_model( iEntity, gszModel );
		new Float:vSizeMin[ 3 ]; 
		new Float:vSizeMax[ 3 ]; 
		new Float:vAngles[ 3 ]; 
		vSizeMin = gLightMinY; 
		vSizeMax = gLightMaxY; 
		vAngles[ 0 ] = 90.0; 
		vAngles[ 2 ] = 90.0; 
		new szRadius[ 4 ], szR[ 4 ], szG[ 4 ], szB[ 4 ];
		new Float:RGB[ 3 ];
		
		format( szRadius, 3, "%d", iRadius );
		format( szR, 3, "%d", iR );
		format( szG, 3, "%d", iG );
		format( szB, 3, "%d", iB );
		
		entity_set_string( iEntity, EV_SZ_noise, szRadius );
		entity_set_string( iEntity, EV_SZ_noise1, szR );
		entity_set_string( iEntity, EV_SZ_noise2, szG );
		entity_set_string( iEntity, EV_SZ_noise3, szB );
		
		RGB[ 0 ] = str_to_float( szR );
		RGB[ 1 ] = str_to_float( szG );
		RGB[ 2 ] = str_to_float( szB );
		
		entity_set_size( iEntity, vSizeMin, vSizeMax );
		
		entity_set_vector( iEntity, EV_VEC_rendercolor, RGB );
		
		entity_set_float( iEntity, EV_FL_scale, 0.25 );
		entity_set_float( iEntity, EV_FL_nextthink, get_gametime() + 0.1 );
		entity_set_origin( iEntity, vOrigin );
		
		return iEntity;
	}
	return 0;
}

SaveLights( id )
{
	if( file_exists( gConfigFile ) )
		delete_file( gConfigFile );

	new iFile = fopen( gConfigFile, "wt" );

	if( !iFile ) return;

	new Float:vOrigin[ 3 ], iEntity, lightCount;

	while( ( iEntity = find_ent_by_class( iEntity, gszLightClassName ) ) > 0 ) 
	{
		entity_get_vector( iEntity, EV_VEC_origin, vOrigin );
	
		new szRadius[ 4 ], szR[ 4 ], szG[ 4 ], szB[ 4 ];
		
		entity_get_string( iEntity, EV_SZ_noise, szRadius, 3 );
		entity_get_string( iEntity, EV_SZ_noise1, szR, 3 );
		entity_get_string( iEntity, EV_SZ_noise2, szG, 3 );
		entity_get_string( iEntity, EV_SZ_noise3, szB, 3 );

		fprintf( iFile, "%f %f %f %s %s %s %s^n", vOrigin[ 0 ], vOrigin[ 1 ], vOrigin[ 2 ], szRadius, szR, szG, szB );
		++lightCount;
	}
	new szName[ 33 ];
	get_user_name( id, szName, 32 );
	//client_print( id, print_chat, "%s %s saved %d light%s! Total entities in map: %d", gszPrefix, szName, lightCount, lightCount == 1 ? "" : "s", entity_count() );
	ColorChat( 0, RED, "^x04%s^x03 %s^x01 saved^x04 %d light%s^x01! Total entites in map:^x04 %d", gszPrefix, szName, lightCount, (lightCount == 1 ? "" : "s"), entity_count() );
	
	fclose( iFile );
}

LoadLights( id ) 
{
	new bool:PrintMessage = false;
	if(id == 0)
	{
		PrintMessage = false;
	}
	else 
	{
		PrintMessage = true;
	}
	new iFile = fopen( gConfigFile, "rt" );

	if( !iFile ) return;
	
	new iEntity = -1;
	while( ( iEntity = find_ent_by_class( iEntity, gszLightClassName ) ) )
		remove_entity( iEntity );
	
	new Float:vOrigin[ 3 ], x[ 16 ], y[ 16 ], z[ 16 ], szData[ sizeof( x ) + sizeof( y ) + sizeof( z ) + 3 ];
	new szRadius[ 4 ], szR[ 4 ], szG[ 4 ], szB[ 4 ];
	new iRadius, iR, iG, iB;
	new lightCount;
	while( !feof( iFile ) ) 
	{
		fgets( iFile, szData, charsmax( szData ) );
		trim( szData );
		
		if( !szData[ 0 ] ) continue;
		
		parse( szData, x, 15, y, 15, z, 15, szRadius, 3, szR, 3, szG, 3, szB, 3 );
		vOrigin[ 0 ] = str_to_float( x );
		vOrigin[ 1 ] = str_to_float( y );
		vOrigin[ 2 ] = str_to_float( z );
		iRadius = str_to_num( szRadius );
		iR = str_to_num( szR );
		iG = str_to_num( szG );
		iB = str_to_num( szB );
		CreateLight( vOrigin, iRadius, iR, iG, iB );
		++lightCount;
	}
	if( PrintMessage && ( lightCount > 0 ) )
	{
		new szName[ 33 ];
		get_user_name( id, szName, 33 );
		//client_print( id, print_chat, "%s %s loaded %d light%s! Total entities in map: %d", gszPrefix, szName, lightCount, lightCount == 1 ? "" : "s", entity_count() );
		ColorChat( 0, RED, "^x04%s^x03 %s^x01 loaded^x04 %d light%s^x01! Total entites in map:^x04 %d", gszPrefix, szName, lightCount, (lightCount == 1 ? "" : "s"), entity_count() );
	}
	fclose( iFile );
}

DeleteAllLights( id ) 
{
	new iDeleted, iEntity = -1;
	while( ( iEntity = find_ent_by_class( iEntity, gszLightClassName ) ) )
	{
		remove_entity( iEntity );
		iDeleted++;
	}
	if( iDeleted > 0 )
	{
		new szName[ 33 ];
		get_user_name( id, szName, 32 );
		//client_print( 0, print_chat, "%s %s deleted all the lights from the map! Total lights: %d", gszPrefix, szName, iDeleted );
		ColorChat( 0, RED, "^x04%s^x03 %s^x01 deleted^x04 all the lights^x01 from the map! Total lights:^x04 %d", gszPrefix, szName, iDeleted );
	}
}

public fwdThink( iEntity ) 
{
	if( !pev_valid( iEntity ) ) return FMRES_IGNORED;
	static szClassname[ 32 ];
	pev( iEntity, pev_classname, szClassname, 31 );
	
	if( equal( szClassname, gszLightClassName ) )
	{
		new Float:vOrigin[ 3 ];
		pev( iEntity, pev_origin, vOrigin );
		
		new szRadius[ 4 ], szR[ 4 ], szG[ 4 ], szB[ 4 ];
		
		pev( iEntity, pev_noise, szRadius, 3 );
		pev( iEntity, pev_noise1, szR, 3 );
		pev( iEntity, pev_noise2, szG, 3 );
		pev( iEntity, pev_noise3, szB, 3 );
		
		new iRadius = str_to_num( szRadius );
		new iR = str_to_num( szR );
		new iG = str_to_num( szG );
		new iB = str_to_num( szB );
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_DLIGHT);
		engfunc(EngFunc_WriteCoord, vOrigin[0]);
		engfunc(EngFunc_WriteCoord, vOrigin[1]);
		engfunc(EngFunc_WriteCoord, vOrigin[2]);
		write_byte(iRadius);    	// radius in 10's
		write_byte(iR);    	// R
		write_byte(iG);		// G
		write_byte(iB);    	// B
		write_byte(3);  	// decay rate
		write_byte(10);    	// life in 10's
		message_end();

		set_pev( iEntity, pev_nextthink, get_gametime() + 0.1 );
	}
	return FMRES_IGNORED;
}  
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
